<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{

    use SoftDeletes;

    protected $fillable = [
        'title',
        'sku',
        'category_id',
        'purchase_price',
        'sell_price',
        'price_type',
        'tax_id',
        'short_description'
    ];

    protected $appends = ['current_stock_quantity', 'total_sell_qty'];

    public function getCurrentStockQuantityAttribute()
    {
        $branch_id = auth()->user()->employee->branch_id;
        $product_id = $this->id;

        /**
         * Debit Quantity
         **/
        $total_purchase_products_qty = \App\Models\PurchaseProduct::where('branch_id', $branch_id)
            ->where('product_id', $product_id)
            ->sum('quantity');

        $branch_requisitions_from = \App\Models\Requisition::where('requisition_from', $branch_id)
            ->where('status', 2)
            ->select('id')
            ->distinct()
            ->get();

        $branch_requisitions_from_qty = \App\Models\RequisitionProduct::whereIn('requisition_id', $branch_requisitions_from)
            ->where('product_id', $product_id)
            ->select('id')
            ->sum('quantity');


        /**
         * Credit Quantity
         **/

        $total_sell_products_qty = \App\Models\SellProduct::where('branch_id', $branch_id)
            ->where('product_id', $product_id)
            ->sum('quantity');

        $branch_requisitions_to = \App\Models\Requisition::where('requisition_to', $branch_id)
            ->where('status', 2)
            ->select('id')
            ->distinct()
            ->get();

        $branch_requisitions_to_qty = \App\Models\RequisitionProduct::whereIn('requisition_id', $branch_requisitions_to)
            ->where('product_id', $product_id)
            ->select('id')
            ->sum('quantity');



        $debit = $total_purchase_products_qty + $branch_requisitions_from_qty;
        $credit = $total_sell_products_qty + $branch_requisitions_to_qty;

        return $debit - $credit;
    }

    public function getTotalSellQtyAttribute(){
        return $this->hasMany(SellProduct::class)
            ->where('branch_id', auth()->user()->employee->branch_id)
            ->sum('quantity');
    }

    public function purchaseProducts()
    {
        return $this->hasMany(PurchaseProduct::class);
    }

    public function sellProducts()
    {
        return $this->hasMany(SellProduct::class);
    }

    public function tax()
    {
        return $this->belongsTo(Tax::class)->withTrashed();
    }

    public function category()
    {
        return $this->belongsTo(Category::class)->withTrashed();
    }

    public function requisitions()
    {
        return $this->hasMany(Requisition::class);
    }



    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        self::creating(function($model){
            $model->created_by =  auth()->user()->id;
            $model->branch_id =  1;
        });
    }
}
