<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PaymentFromCustomer extends Model
{
    protected $fillable = ['payment_date','amount','note'];

    protected $dates = ['payment_date'];

    public function branch()
    {
        return $this->belongsTo(Branch::class)->withTrashed();
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class)->withTrashed();
    }

    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        self::creating(function($model){
            $model->branch_id =  auth()->user()->employee->branch_id;
        });
    }
}
