<?php

namespace App\Models;

use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Draft extends Model
{
    protected $dates = ['archive_date'];

    protected $fillable = ['sub_total', 'discount','grand_total_price'];


    public function draftProducts()
    {
        return $this->hasMany(DraftProduct::class)->with('product');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class)->withTrashed();
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class)->withTrashed();
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'created_by')->withTrashed();
    }

    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        self::creating(function($model){
            $model->archive_date = Carbon::now();
            $model->branch_id =  auth()->user()->employee->branch_id;
            $model->inquiry_id = Carbon::now()->format('d').'-'.Carbon::now()->format('m').'-'.Carbon::now()->format('Y').'-'.rand(100,999);
        });
    }
}
